title Convert a string to binary. coded by wbinvd

        include segments.inc

        public  __antob

        startcode
;Convert string EDI to binary in EAX
;In:    EDI     zero terminated string
;       BH      Base (10b=bin,10o=oct,10d=decimal,10h=hex)
;Out:   CF=1    Not a number (or wrong base)
;         EAX   zero
;       CF=0
;         EAX   Number
;Regs:  EAX
__antob         proc near
        push    edx ebx edi
        mov     al_,[edi]
        test    al_,al_
        jz      short @@ErrorSetCF
        cmp     al_,'-'
        je      short @@incedi
        cmp     al_,'+'
        jne     short @@dont
@@incedi:
ifdef UNICODE
        inc     edi
endif
        inc     edi
@@dont:
        xor     eax,eax
        xor     edx,edx
        movzx   ebx,bh                  ;EBX=number base
@@countloop:
        mov     al_,[edi]
ifdef UNICODE
        inc     edi
endif
        inc     edi
ifdef UNICODE
        test    ah,ah
        jnz     short @@error           ;Not ascii
endif
        sub     al,'0'                  ;get binary number
        jb      short @@error???
        cmp     al,0Ah
        jb      short @@nothexdigit
        cmp     al,'A'-'0'
        jb      short @@error
        cmp     al,'Z'-'0'
        jbe     short @@AZ
        cmp     al,'a'-'0'
        jb      short @@error
if 01
        ;this is much faster. We'll do the test after the jmp
        sub     al,'a'-('0'+10)
        jmp     short @@nothexdigit
else
        cmp     al,'z'-'0'
        ja      short @@error
        sub     al,'a'-('0'+10)
        jnc     short @@nothexdigit
        jc      short @@error
endif
@@error???:
        cmp     al,0-'0'
        je      short @@loopend
@@error:
        xor     eax,eax
        pop     edi
        cmc
        jc      short @@666
@@AZ:
        sub     al,'A'-('0'+10)
@@nothexdigit:
        cmp     al,bl
        jae     short @@error
        imul    edx,ebx
        add     edx,eax
        jmp     short @@countloop
@@loopend:
        pop     edi
        xchg    edx,eax
        cmp     CharType ptr [edi],'-'
        jne     short @@notneg
        neg     eax
@@notneg:
        clc
@@666:
        pop     ebx edx
        ret
@@ErrorSetCF:
        pop     edi
        stc
        jc      short @@666
__antob         endp
        endcode
        end
